package ui

import (
	"time"
)

type Notifier interface {
	Notify(kind NotificationKind, text string) (*Notification, error)
	NotifyAndForget(kind NotificationKind, text string, ttl time.Duration) error
	ScheduleNotify(postpone time.Duration, kind NotificationKind, text string) (*Notification, error)
}

type osNotifier interface {
	Notify(title, text, iconPath string, opts ...osNotifyOption) (osNotification, error)
	Close() error
}

type osNotifyOption interface {
	isOSNotifierOption()
}

type osNotifyUrgency uint8

const (
	osNotificationUrgencyNormal osNotifyUrgency = iota
	osNotificationUrgencyCritical
)

type osNotifierOptionUrgency struct {
	osNotifyOption
	urgency osNotifyUrgency
}

func withOSNotifyUrgency(u osNotifyUrgency) osNotifierOptionUrgency {
	return osNotifierOptionUrgency{
		urgency: u,
	}
}
