package ui

/*
#cgo CFLAGS: -x objective-c
#cgo LDFLAGS: -framework Foundation
#import <Foundation/Foundation.h>

@interface uiUserNotificationCenterDelegate : NSObject<NSUserNotificationCenterDelegate>

- (BOOL)userNotificationCenter:(NSUserNotificationCenter*)center
    shouldPresentNotification:(NSUserNotification*)notification;

@end

@implementation uiUserNotificationCenterDelegate

- (BOOL)userNotificationCenter:(NSUserNotificationCenter*)center
    shouldPresentNotification:(NSUserNotification*)notification
{
    return YES;
}

@end

bool isBundled() {
    return [[NSBundle mainBundle] bundleIdentifier] != nil;
}

void sendNotification(const char *title, const char *body, char** outID) {
    NSUserNotificationCenter *center = [NSUserNotificationCenter defaultUserNotificationCenter];
    if (center.delegate == nil) {
        center.delegate = [[uiUserNotificationCenterDelegate new] autorelease];
    }

	@autoreleasepool {
    	NSUserNotification *notification = [[NSUserNotification new] init];
		NSString *identifier = [[NSUUID UUID] UUIDString];
    	notification.title = [NSString stringWithUTF8String:title];
    	notification.informativeText = [NSString stringWithUTF8String:body];
   		notification.identifier = identifier;
    	[center deliverNotification:notification];
		*outID = strdup([identifier UTF8String]);
	}
}

void closeNotification(const char* identifier) {
    NSUserNotificationCenter *center = [NSUserNotificationCenter defaultUserNotificationCenter];

	@autoreleasepool {
		NSString *id = [NSString stringWithUTF8String:identifier];
		NSArray *notifications = [center deliveredNotifications];
		for (NSUserNotification *n in notifications) {
			if ([n.identifier compare:id] == NSOrderedSame) {
				[center removeDeliveredNotification:n];
				break;
			}
		}
	}
}
*/
import "C"
import (
	"unsafe"
)

var _ osNotifier = (*nativeNotifier)(nil)

type nativeNotifier struct {
}

type nativeNotification struct {
	id string
}

func isNativeNotifierSupported() bool {
	return bool(C.isBundled())
}

func newNativeNotifier() (osNotifier, error) {
	return &nativeNotifier{}, nil
}

func (n *nativeNotifier) Notify(title, text, _ string, _ ...osNotifyOption) (osNotification, error) {
	var cIdentifier *C.char
	defer C.free(unsafe.Pointer(cIdentifier))
	cTitle := C.CString(title)
	defer C.free(unsafe.Pointer(cTitle))
	cText := C.CString(text)
	defer C.free(unsafe.Pointer(cText))

	C.sendNotification(cTitle, cText, &cIdentifier)
	return &nativeNotification{
		id: C.GoString(cIdentifier),
	}, nil
}

func (n *nativeNotifier) Close() error {
	return nil
}

func (n *nativeNotification) Close() {
	cIdentifier := C.CString(n.id)
	defer C.free(unsafe.Pointer(cIdentifier))

	C.closeNotification(cIdentifier)
}
