package ui

import (
	"fmt"
	"os/exec"
)

var _ osNotifier = (*osaNotifier)(nil)

type osaNotifier struct {
	osaPath string
}

type osaNotification struct {
}

func newOsaNotifier() (osNotifier, error) {
	osa, err := exec.LookPath("osascript")
	if err != nil {
		return nil, fmt.Errorf("can't find osascript: %w", err)
	}

	return &osaNotifier{
		osaPath: osa,
	}, nil
}

func (n *osaNotifier) Notify(title, text, _ string, _ ...osNotifyOption) (osNotification, error) {
	script := fmt.Sprintf(`display notification %q with title %q`, text, title)
	cmd := exec.Command(n.osaPath, "-e", script)
	if err := cmd.Run(); err != nil {
		return nil, fmt.Errorf("failed to call osascript: %w", err)
	}

	return &osaNotification{}, nil
}

func (n *osaNotifier) Close() error {
	return nil
}

func (n *osaNotification) Close() {
}
