package ui

import "a.yandex-team.ru/library/go/core/log"

type Option interface {
	isOption()
}

type optionIconsPath struct {
	Option
	iconsPath string
}

func WithIconsPath(iconsPath string) Option {
	return optionIconsPath{iconsPath: iconsPath}
}

type optionLogger struct {
	Option
	log log.Logger
}

func WithLogger(l log.Logger) Option {
	return optionLogger{log: l}
}

type optionSocketsNames struct {
	Option
	sockets []string
}

func WithSocketsNames(items ...string) Option {
	return optionSocketsNames{sockets: items}
}
