GO_LIBRARY()

OWNER(
    buglloc
    g:security
)

IF (OS_DARWIN)
    CGO_CFLAGS(
        -x
        objective-c
    )

    CGO_LDFLAGS(
        -framework
        Foundation
    )
ENDIF()

SRCS(
    app.go
    console_app.go
    notification.go
    notifier.go
    opts.go
)

IF (OS_FREEBSD)
    SRCS(
        gui_app_other.go
        notifier_unix.go
    )
ENDIF()

IF (OS_LINUX)
    SRCS(
        gui_app_other.go
        notifier_unix.go
    )
ENDIF()

IF (OS_DARWIN)
    SRCS(
        gui_app_other.go
        notifier_darwin.go
        notifier_osa_darwin.go
    )

    CGO_SRCS(notifier_native_darwin.go)
ENDIF()

IF (OS_WINDOWS)
    SRCS(
        gui_app_notifier_windows.go
        gui_app_windows.go
        menu_builder_windows.go
        notifier_windows.go
    )
ENDIF()

END()

IF (OS_WINDOWS)
    RECURSE(winapi)
ENDIF()
