package version

import (
	"fmt"

	"a.yandex-team.ru/library/go/core/buildinfo"
)

const (
	ToolName      = "skotty"
	majorMinorVer = "0.9"
)

func Full() string {
	return fmt.Sprintf("%s.%s", majorMinorVer, patchVersion())
}

func IsDirty() bool {
	return patchVersion() == "0"
}

func patchVersion() string {
	patch := buildinfo.Info.ArcadiaSourceRevision
	if patch == "" || patch == "-1" {
		return "0"
	}

	return patch
}
