package yubiconf

import "fmt"

type ApplicationID int

const (
	ApplicationOTP   ApplicationID = 0x01
	ApplicationU2F   ApplicationID = 0x02
	ApplicationOPGP  ApplicationID = 0x08
	ApplicationPIV   ApplicationID = 0x10
	ApplicationOATH  ApplicationID = 0x20
	ApplicationFIDO2 ApplicationID = 0x200
)

var AllApplications = []ApplicationID{
	ApplicationOTP,
	ApplicationU2F,
	ApplicationOPGP,
	ApplicationPIV,
	ApplicationOATH,
	ApplicationFIDO2,
}

func (a ApplicationID) String() string {
	switch a {
	case ApplicationOTP:
		return "ApplicationOTP"
	case ApplicationU2F:
		return "U2F"
	case ApplicationOPGP:
		return "OPGP"
	case ApplicationPIV:
		return "PIV"
	case ApplicationOATH:
		return "OATH"
	case ApplicationFIDO2:
		return "FIDO2"
	default:
		return fmt.Sprintf("app_%d", int(a))
	}
}

func ParseApplicationID(s string) (ApplicationID, error) {
	switch s {
	case "OTP":
		return ApplicationOTP, nil
	case "U2F":
		return ApplicationU2F, nil
	case "OPGP":
		return ApplicationOPGP, nil
	case "PIV":
		return ApplicationPIV, nil
	case "OATH":
		return ApplicationOATH, nil
	case "FIDO2":
		return ApplicationFIDO2, nil
	default:
		return 0, fmt.Errorf("unsupported app: %s", s)
	}
}
