package yubikey

import (
	"fmt"
	"strings"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/libs/go/piv"
	"a.yandex-team.ru/security/skotty/skotty/internal/logger"
)

type Card struct {
	Name   string
	Serial uint32
}

func (c Card) String() string {
	return fmt.Sprintf("Yubikey #%d", c.Serial)
}

func Cards() ([]Card, error) {
	cards, err := piv.Cards()
	if err != nil {
		return nil, fmt.Errorf("can't list yubikeys: %w", err)
	}

	out := make([]Card, 0, len(cards))
	for _, name := range cards {
		func() {
			if !strings.Contains(strings.ToLower(name), "yubikey") {
				return
			}

			yk, err := piv.Open(name)
			if err != nil {
				logger.Error("failed to open card", log.String("card_name", name), log.Error(err))
				return
			}

			defer func() {
				_ = yk.Close()
			}()

			serial, err := yk.Serial()
			if err != nil {
				logger.Error("failed to get card serial", log.String("card_name", name), log.Error(err))
				return
			}

			out = append(out, Card{
				Name:   name,
				Serial: serial,
			})
		}()
	}

	return out, nil
}
