package osutil

import "os/exec"

func IsOpenInBrowserSupported() bool {
	_, err := exec.LookPath(openInBrowserBinary())
	return err == nil
}

func OpenInBrowser(url string) error {
	if !IsOpenInBrowserSupported() {
		return ErrNotSupported
	}

	cmd := buildOpenInBrowserCommand(url)
	return cmd.Run()
}
