package osutil

import (
	"os"
	"os/exec"
	"strings"
)

// "Official" way of detecting WSL: https://github.com/Microsoft/WSL/issues/423#issuecomment-221627364
func isWSL() bool {
	rawRelease, err := os.ReadFile("/proc/sys/kernel/osrelease")
	if err != nil {
		return false
	}

	release := strings.ToLower(string(rawRelease))
	return strings.Contains(release, "microsoft") || strings.Contains(release, "wsl")
}

func openInBrowserBinary() string {
	if isWSL() {
		return "rundll32.exe"
	}

	return "xdg-open"
}

func buildOpenInBrowserCommand(url string) *exec.Cmd {
	if isWSL() {
		return exec.Command("rundll32.exe", "url.dll,FileProtocolHandler", url)
	}

	return exec.Command("xdg-open", url)
}
