package osutil

import (
	"crypto/x509"
	"fmt"
	"strings"
)

func RemoveFromCertStorage(certs ...*x509.Certificate) error {
	serials := make([]string, len(certs))
	for i, cert := range certs {
		serials[i] = strings.ToUpper(cert.SerialNumber.Text(16))
	}

	script := fmt.Sprintf(`Get-ChildItem Cert:\CurrentUser\My | Where-Object {$_.Issuer -match "skotty" -and $_.SerialNumber.TrimStart("0") -in "%s"} | Remove-Item`, strings.Join(serials, `","`))
	return runScript([]byte(script))
}
