//go:build linux || darwin || freebsd
// +build linux darwin freebsd

package osutil

import (
	"fmt"

	"golang.org/x/sys/unix"
)

func DisableCoreDumps() error {
	if err := unix.Setrlimit(unix.RLIMIT_CORE, &unix.Rlimit{Cur: 0, Max: 0}); err != nil {
		return fmt.Errorf("could not set rlimit: %w", err)
	}
	return nil
}
