package osutil

import (
	"fmt"

	"golang.org/x/sys/unix"
)

func SetNoDumpable() error {
	if err := unix.Prctl(unix.PR_SET_DUMPABLE, 0, 0, 0, 0); err != nil {
		return fmt.Errorf("could not set PR_SET_DUMPABLE: %w", err)
	}
	return nil
}
