package sysenv

import (
	"bytes"
	"fmt"
	"os/exec"
)

func safeExec(command string, args ...string) error {
	name, err := exec.LookPath(command)
	if err != nil {
		return nil
	}

	c := exec.Command(name, args...)
	var stdout, stdin, stderr bytes.Buffer
	c.Stdin = &stdin
	c.Stdout = &stdout
	c.Stderr = &stderr

	if err := c.Run(); err != nil {
		return fmt.Errorf("failed to execute: name %s: %w", c, err)
	}

	return nil
}
