package sysenv

func Export(envs map[string]string) error {
	envSlice := make([]string, 0, len(envs))
	for k, v := range envs {
		envSlice = append(envSlice, k+"="+v)
	}

	toCall := []struct {
		name string
		args []string
	}{
		{
			name: "systemctl",
			args: append(
				[]string{"--user", "set-environment"},
				envSlice...,
			),
		},
		{
			name: "dbus-update-activation-environment",
			args: append([]string{"--systemd"}, envSlice...),
		},
	}

	for _, c := range toCall {
		//TODO(buglloc): log err, plz
		_ = safeExec(c.name, c.args...)
	}

	return nil
}
