package osutil

import (
	"os"
	"path/filepath"
	"strings"

	"github.com/mattn/go-isatty"
)

func CheckInteractiveTerm() (string, bool) {
	if isatty.IsCygwinTerminal(os.Stdout.Fd()) {
		args := []string{
			filepath.Base(os.Args[0]),
		}
		args = append(args, os.Args[1:]...)

		msg := "You are running Skotty under Cygwin/MSYS2 terminal, some interactive features may not work or work incorrectly.\n" +
			"Please rerun Skotty with winpty: winpty " + strings.Join(args, " ") + "\n" +
			"Or use another terminal emulator (e.g. Windows Console, Windows PowerShell, cmd and so on)."

		return msg, false
	}

	return "", true
}
