package osutil

import (
	"fmt"
	"os/user"
	"strings"
)

func UserName() (string, error) {
	u, err := user.Current()
	if err != nil {
		return "", fmt.Errorf("can't get current user: %w", err)
	}

	if idx := strings.LastIndexByte(u.Username, '\\'); idx > 0 {
		return u.Username[idx+1:], nil
	}

	return u.Username, nil
}
