GO_LIBRARY()

OWNER(
    buglloc
    g:security
)

SRCS(
    browser.go
    launcher.go
    service.go
)

IF (OS_LINUX)
    SRCS(
        browser_linux.go
        certstorage_other.go
        coredump_unix.go
        dumpable_linux.go
        service_linux.go
        term_other.go
        user_unix.go
    )
ENDIF()

IF (OS_FREEBSD)
    SRCS(
        browser_freebsd.go
        certstorage_other.go
        coredump_unix.go
        dumpable_other.go
        service_freebsd.go
        term_other.go
        user_unix.go
    )
ENDIF()

IF (OS_DARWIN)
    SRCS(
        browser_darwin.go
        certstorage_other.go
        coredump_unix.go
        dumpable_other.go
        service_darwin.go
        term_other.go
        user_unix.go
    )
ENDIF()

IF (OS_WINDOWS)
    SRCS(
        browser_windows.go
        certstorage_windows.go
        coredump_other.go
        dumpable_other.go
        service_windows.go
        term_windows.go
        user_windows.go
    )
ENDIF()

GO_EMBED_PATTERN(template/launchd.service)

GO_EMBED_PATTERN(template/systemd.service)

END()

RECURSE(sysenv)
