package skottyctl

import (
	"context"
	"net"
	"time"

	"google.golang.org/grpc"
	"google.golang.org/grpc/credentials/insecure"
)

const (
	dialTimeout = 500 * time.Millisecond
)

func NewConnection(address string, opts ...grpc.DialOption) (*grpc.ClientConn, error) {
	dialer := net.Dialer{
		Timeout: dialTimeout,
	}

	opts = append(
		opts,
		grpc.WithBlock(),
		grpc.WithTransportCredentials(insecure.NewCredentials()),
		grpc.FailOnNonTempDialError(true),
		grpc.WithContextDialer(
			func(ctx context.Context, _ string) (net.Conn, error) {
				return dialer.DialContext(ctx, "unix", address)
			},
		),
	)

	return grpc.Dial("passthrough:///unix", opts...)
}
