package skottyctl

import "context"

func AgentPID(sockPath string) int {
	ctl, err := NewClient(sockPath)
	if err != nil {
		return -1
	}
	defer func() { _ = ctl.Close() }()

	status, err := ctl.Status(context.Background())
	if err != nil {
		return -1
	}

	return status.PID
}
