package sshutil

import (
	"golang.org/x/crypto/ssh"
)

func Fingerprint(key ssh.PublicKey) string {
	if cert, ok := key.(*ssh.Certificate); ok {
		return ssh.FingerprintSHA256(cert.Key)
	}

	return ssh.FingerprintSHA256(key)
}
