package sshclient

import (
	"fmt"
	"strings"
	"unicode"

	"github.com/blang/semver/v4"
)

func parseSSHVersion(clientName string, in string) (semver.Version, error) {
	idx := strings.IndexFunc(in, func(r rune) bool {
		return unicode.IsSpace(r) || r == ','
	})
	if idx > 0 {
		in = in[:idx]
	}

	in = strings.TrimSpace(in)
	dirtyVer := strings.TrimPrefix(in, clientName+"_")
	if dirtyVer == in {
		return semver.Version{}, fmt.Errorf("unexpected client info: %s", in)
	}

	idx = strings.IndexAny(dirtyVer, "p, \t\n")
	if idx > 0 {
		dirtyVer = dirtyVer[:idx]
	}

	return semver.ParseTolerant(dirtyVer)
}
