package main

import (
	"errors"

	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/skotty/libs/isroot"
	"a.yandex-team.ru/security/skotty/win32ssh-installer/internal/installer"
	"a.yandex-team.ru/security/skotty/win32ssh-installer/internal/sshrelease"
)

var installArgs struct {
	Version string
	Sha512  string
}

var installCmd = &cobra.Command{
	Use:          "install",
	SilenceUsage: true,
	Short:        "Install Win32OpenSSH",
	RunE: func(_ *cobra.Command, _ []string) error {
		if !isroot.IsRoot() {
			return errors.New("win32ssh-installer must be called from the administrative console")
		}

		return installer.Install(installArgs.Version, installArgs.Sha512)
	},
}

func init() {
	f := installCmd.PersistentFlags()
	f.StringVar(&installArgs.Version, "version", sshrelease.Version, "Win32OpenSSH version to install")
	f.StringVar(&installArgs.Sha512, "sha512", sshrelease.Sha512Hash, "installer sha512 sum")
}
