package main

import (
	"os"

	"github.com/spf13/cobra"
)

var rootCmd = &cobra.Command{
	Use:          "win32ssh-installer",
	SilenceUsage: true,
	Short:        "Win32OpenSSH installer",
	Long: "Win32OpenSSH installer installs Win32OpenSSH follow those instruction: " +
		"https://github.com/PowerShell/Win32-OpenSSH/wiki/Install-Win32-OpenSSH-Using-MSI",
}

func init() {
	rootCmd.AddCommand(
		installCmd,
	)
}

func main() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}
