package installer

import (
	_ "embed"
	"fmt"
	"os"
	"os/exec"
	"syscall"

	"a.yandex-team.ru/security/skotty/win32ssh-installer/internal/logger"
)

// https://stackoverflow.com/a/27872686
//go:embed disable_agent.ps1
var disableAgentScript []byte

func disableAgent() error {
	return runScript(disableAgentScript)
}

func runScript(content []byte) error {
	tmpfile, err := os.CreateTemp("", "win32ssh-installer-*.ps1")
	if err != nil {
		return fmt.Errorf("create script: %w", err)
	}
	defer func() {
		if err != nil {
			return
		}

		_ = os.Remove(tmpfile.Name())
	}()

	if _, err = tmpfile.Write(content); err != nil {
		return fmt.Errorf("write script: %w", err)
	}

	if err = tmpfile.Close(); err != nil {
		return fmt.Errorf("close script: %w", err)
	}

	cmd := exec.Command("PowerShell", "–NoLogo", "–NoProfile", "-ExecutionPolicy", "Bypass", "-File", tmpfile.Name())
	logger.Infof("starts: %s", cmd)
	cmd.Stdout = os.Stdout
	cmd.Stderr = os.Stderr
	cmd.SysProcAttr = &syscall.SysProcAttr{
		HideWindow: false,
	}
	if err = cmd.Run(); err != nil {
		return fmt.Errorf("run service script %q: %w", cmd, err)
	}

	return nil
}
