package logger

import (
	"fmt"

	"go.uber.org/zap"
	"go.uber.org/zap/zapcore"

	"a.yandex-team.ru/library/go/core/log"
	aZap "a.yandex-team.ru/library/go/core/log/zap"
)

var l = func() log.Logger {
	cfg := zap.Config{
		Level:       zap.NewAtomicLevelAt(zap.InfoLevel),
		Development: false,
		Encoding:    "console",
		EncoderConfig: zapcore.EncoderConfig{
			TimeKey:        "ts",
			LevelKey:       "level",
			NameKey:        "logger",
			MessageKey:     "msg",
			CallerKey:      zapcore.OmitKey,
			FunctionKey:    zapcore.OmitKey,
			StacktraceKey:  zapcore.OmitKey,
			LineEnding:     zapcore.DefaultLineEnding,
			EncodeLevel:    zapcore.LowercaseLevelEncoder,
			EncodeTime:     zapcore.ISO8601TimeEncoder,
			EncodeDuration: zapcore.SecondsDurationEncoder,
		},
		OutputPaths:      []string{"stderr"},
		ErrorOutputPaths: []string{"stderr"},
	}

	l, err := aZap.New(cfg)
	if err != nil {
		panic(fmt.Sprintf("can't initialize logger: %v", err))
	}

	return l.AddCallerSkip(1)
}()

func Info(msg string, fields ...log.Field) {
	l.Info(msg, fields...)
}

func Infof(format string, args ...interface{}) {
	l.Infof(format, args...)
}

func Warn(msg string, fields ...log.Field) {
	l.Warn(msg, fields...)
}

func Warnf(format string, args ...interface{}) {
	l.Warnf(format, args...)
}

func Error(msg string, fields ...log.Field) {
	l.Error(msg, fields...)
}

func Errorf(format string, args ...interface{}) {
	l.Errorf(format, args...)
}
