package sshrelease

import (
	"net/url"
	"strings"
)

const Version = "8.9.1.0"
const Sha512Hash = "476941226beb5450f8fa39d75c60ff93596ff85bfdceaa781b8cc59118c398c22353d4aeb4ff8f3c69af9f95761fe47710f40001926946d679ba05c727a9311d"
const DownloadURLTmpl = "https://github.com/PowerShell/Win32-OpenSSH/releases/download/v{version}p1-Beta/OpenSSH-Win64-v{version}.msi"

func DownloadURL(version string) string {
	return strings.ReplaceAll(DownloadURLTmpl, "{version}", url.PathEscape(version))
}
