package main

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	"gopkg.in/yaml.v2"

	"a.yandex-team.ru/security/skotty/wsl2proxy/internal/config"
)

var configArgs struct {
	Config string
}

func init() {
	flags := configCmd.PersistentFlags()
	flags.StringVarP(&configArgs.Config, "config", "c", "", "config path")
}

var configCmd = &cobra.Command{
	Use:          "config",
	SilenceUsage: true,
	Short:        "prints config",
	RunE: func(_ *cobra.Command, _ []string) error {
		cfg, err := config.Load(configArgs.Config)
		if err != nil {
			return fmt.Errorf("unable to load config: %w", err)
		}

		return yaml.NewEncoder(os.Stdout).Encode(cfg)
	},
}
