//go:build !windows
// +build !windows

package main

import (
	"fmt"
	"net"
	"time"
)

func dialAddr(scheme, addr string) (net.Conn, error) {
	dialTimeout := 2 * time.Second
	switch scheme {
	case "unix":
		return net.DialTimeout("unix", addr, dialTimeout)
	default:
		return nil, fmt.Errorf("unsupported scheme: %s", scheme)
	}
}
