package main

import (
	"fmt"
	"net"
	"time"

	"github.com/Microsoft/go-winio"
)

func dialAddr(scheme, addr string) (net.Conn, error) {
	dialTimeout := 2 * time.Second
	switch scheme {
	case "pipe", "":
		return winio.DialPipe(addr, &dialTimeout)
	case "unix":
		return net.DialTimeout("unix", addr, dialTimeout)
	default:
		return nil, fmt.Errorf("unsupported scheme: %s", scheme)
	}
}
