package main

import (
	"os"

	"github.com/spf13/cobra"
)

var rootCmd = &cobra.Command{
	Use:          "wsl2proxy",
	SilenceUsage: true,
	Short:        "WSL2 to Windows proxy",
}

func init() {
	rootCmd.AddCommand(
		startCmd,
		forwardCmd,
		configCmd,
		versionCmd,
	)
}

func main() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}
