package listener

import "a.yandex-team.ru/library/go/core/log"

type Option interface {
	isOption()
}

type loggerOption struct {
	Option
	log log.Logger
}

func WithLogger(log log.Logger) Option {
	return loggerOption{
		log: log,
	}
}

type proxyBinaryOption struct {
	Option
	binary string
	args   []string
}

func WithProxyBinary(binary string, args ...string) Option {
	return proxyBinaryOption{
		binary: binary,
		args:   args,
	}
}

type onListenOption struct {
	Option
	onListenFn func(spec Spec)
}

func WithOnListen(fn func(spec Spec)) Option {
	return onListenOption{
		onListenFn: fn,
	}
}
