package pipeproxy

import (
	"io"
	"os/exec"
)

type PipeConn struct {
	Writer io.WriteCloser
	Reader io.ReadCloser
}

func (c *PipeConn) Read(p []byte) (n int, err error) {
	return c.Reader.Read(p)
}

func (c *PipeConn) Write(p []byte) (n int, err error) {
	return c.Writer.Write(p)
}

func (c *PipeConn) Close() error {
	rErr := c.Reader.Close()
	wErr := c.Writer.Close()
	if rErr != nil {
		return rErr
	}
	if wErr != nil {
		return wErr
	}
	return nil
}

var _ io.ReadWriteCloser = (*CmdConn)(nil)

type CmdConn struct {
	PipeConn
	Cmd *exec.Cmd
}

func (c *CmdConn) Close() (err error) {
	defer func() {
		switch {
		case err == nil:
			err = c.Cmd.Wait()
		default:
			_ = c.Cmd.Process.Kill()
		}

		_ = c.Reader.Close()
	}()

	err = c.Writer.Close()
	return
}
