package pipeproxy

import (
	"io"
	"strings"
)

func Proxy(srvConn, cliConn io.ReadWriteCloser) error {
	serverClosed := make(chan struct{}, 1)
	clientClosed := make(chan struct{}, 1)
	errCh := make(chan error, 2)

	go broker(srvConn, cliConn, clientClosed, errCh)
	go broker(cliConn, srvConn, serverClosed, errCh)

	var waitFor chan struct{}
	select {
	case <-clientClosed:
		_ = srvConn.Close()
		waitFor = serverClosed
	case <-serverClosed:
		_ = cliConn.Close()
		waitFor = clientClosed
	}

	<-waitFor
	err := <-errCh
	if err == nil {
		err = <-errCh
	}
	return err
}

func broker(dst, src io.ReadWriteCloser, srcDone chan<- struct{}, errCh chan<- error) {
	errSender := false
	sendError := func(err error) {
		if errSender || err == nil || strings.Contains(err.Error(), "use of closed network connection") {
			return
		}

		errSender = true
		errCh <- err
	}
	_, err := io.Copy(dst, src)
	sendError(err)

	err = src.Close()
	sendError(err)

	srcDone <- struct{}{}
	if !errSender {
		errCh <- nil
	}
}
