package pipeproxy

import (
	"context"
	"fmt"
	"os"
	"os/exec"
)

type PipeProxy struct {
	binaryPath string
	args       []string
}

func NewPipeProxy(binaryPath string, args ...string) *PipeProxy {
	return &PipeProxy{
		binaryPath: binaryPath,
		args:       args,
	}
}

func (n *PipeProxy) Start(ctx context.Context, addr string) (*Session, error) {
	cmd := exec.CommandContext(ctx, n.binaryPath, append(n.args, addr)...)
	stdin, err := cmd.StdinPipe()
	if err != nil {
		return nil, fmt.Errorf("unable to create stdin pipe: %w", err)
	}

	stdout, err := cmd.StdoutPipe()
	if err != nil {
		_ = stdin.Close()
		return nil, fmt.Errorf("unable to create stdout pipe: %w", err)
	}

	cmd.Stderr = os.Stderr
	if err := cmd.Start(); err != nil {
		_ = stdin.Close()
		_ = stdout.Close()
		return nil, fmt.Errorf("unable to start proxy: %w", err)
	}

	conn := &CmdConn{
		PipeConn: PipeConn{
			Writer: stdin,
			Reader: stdout,
		},
		Cmd: cmd,
	}
	session, err := NewSession(conn)
	if err != nil {
		_ = conn.Close()
		return nil, fmt.Errorf("unable to create new session: %w", err)
	}

	return session, nil
}
