package shellutil

import (
	"bytes"
	"fmt"
	"os"
	"path/filepath"

	"a.yandex-team.ru/security/skotty/wsl2proxy/internal/listener"
)

func Listeners(spec listener.Spec) []byte {
	if len(spec.Pairs) == 0 {
		return []byte{'\n'}
	}

	shell := os.Getenv("SHELL")
	var socketFmt func(envName, socket string) string
	switch filepath.Base(shell) {
	case "fish":
		socketFmt = fishSocket
	case "csh":
		socketFmt = cshSocket
	default:
		socketFmt = bourneSocket
	}

	out := bytes.NewBuffer(nil)
	for _, p := range spec.Pairs {
		out.WriteString(socketFmt(p.Name, p.Src))
		out.WriteByte('\n')
	}

	return out.Bytes()
}

func bourneSocket(envName, socket string) string {
	return fmt.Sprintf("%s=%q; export %s", envName, socket, envName)
}

func fishSocket(envName, socket string) string {
	return fmt.Sprintf("set -gx %s %q", envName, socket)
}

func cshSocket(envName, socket string) string {
	return fmt.Sprintf("setenv %s %q;", envName, socket)
}
