from lb_consumer import main as consumer_main
from vault_client.instances import Production as VaultClient


def main():
    client = VaultClient(decode_files=True)

    secrets = client.get_version("sec-01dsqtm7gg5qj4egphpx3ztp6e").get("value")

    with open("topics.txt", "r") as topics_file:
        topics = topics_file.readlines()

    topics = [elem.strip() for elem in topics]

    logbroker_host = "man.logbroker.yandex.net"
    logbroker_host_port = 2135
    connection_timeout = 60
    dry_run = False
    read_infly_count = 10
    max_messages_count = 20
    max_time_lag = 3600
    lock = True
    read_only_local = True

    consumer_main(hec_token=secrets["hec_token"],
         topics=topics,
         logbroker_client=secrets["logbroker_client"],
         logbroker_host=logbroker_host,
         logbroker_host_port=logbroker_host_port,
         connection_timeout=connection_timeout,
         dry_run=dry_run,
         tvm_client_id=secrets["tvm_client_id"],
         tvm_secret_key=secrets["tvm_secret_key"],
         tvm_logbroker_client_id=secrets["tvm_logbroker_client_id"],
         lock=lock,
         read_infly_count=read_infly_count,
         max_messages_count=max_messages_count,
         read_only_local=read_only_local,
         max_time_lag=max_time_lag
         )


if __name__ == "__main__":
    main()
