import psycopg2
from hec_sender import SplunkHECSender
import pandas as pd
import yaml
import os
from time import sleep


def load_config(config_path: str):
    with open(config_path, 'r') as config_file:
        config = yaml.safe_load(config_file)
    return config


def db_connection(database, user, password, host, port):
    connection = psycopg2.connect(database=database, user=user, password=password, host=host, port=port)
    cursor = connection.cursor()
    return cursor


# check tables
def get_tables_from_db(cursor):
    cursor.execute("SELECT table_schema, table_name FROM information_schema.tables")
    # Fetch all rows from database
    tables = cursor.fetchall()
    res_tables = []
    for i in tables:
        a = i[0] + '.' + i[1]
        res_tables.append(a)
    #print(res_tables)
    return res_tables


def get_table_info(table_marker, tables, cursor, hec_sender_connection):
    for i in tables:
        if table_marker in i:
            # check tables
            try:
                sql = f"SELECT * FROM {i}"
                cursor.execute(sql)
                # Fetch all rows from database
                data = cursor.fetchall()
                col_names = []

                for elt in cursor.description:
                    col_names.append(elt[0])
                df = pd.DataFrame(data, columns=col_names)

                for k, v in dict(df.dtypes).items():
                    if v == "datetime64[ns]":
                        df[k] = df[k].astype(str)

                dict1 = df.to_dict('index')
                list1 = []
                for j in list(dict1.values()):
                    j.update({"table_name": i})
                    list1.append(j)
                print(f"OK table - {i}")
                hec_sender_connection.send_data(list1)  # data_variable can be string, dict or list of dicts.
            except:
                print(f"ERROR table - {i}")


def main():
    user = "soc"
    config_path = "config.yaml"

    # get db config
    config = load_config(config_path)

    #creds
    hec_token =os.environ.get('HEC_TOKEN')
    password_db = os.environ.get('PG_PASS')
    host_db = config['host_db']

    # work with dbs
    for i in config["databases"].keys():
        db_name = config["databases"][i]['db']
        table_marker = config["databases"][i]['table_string']
        # table marker string
        hec_sender_connection = SplunkHECSender(hec_token, index=config['splunk_index'],
                                                sourcetype=config['splunk_sourcetype'],
                                                hec_verify_ssl=False)
        cursor = db_connection(database=db_name,
                               user=user,
                               password=password_db,
                               host=host_db,
                               port=6432)

        tables_from_db = get_tables_from_db(cursor)
        get_table_info(table_marker, tables_from_db, cursor, hec_sender_connection)


if __name__ == "__main__":
    while True:
        main()
        sleep(84600)