import csv
from requests import Session
from requests.auth import HTTPBasicAuth

from zeep import Client
from zeep.transports import Transport

from hec_sender import SplunkHECSender


username = 'anton-k@ld.yandex.ru'
password = ''
hec_token = ''
sccm_host = 'iva-cfgp01-db01.ld.yandex.ru'

reports = [
    {
        'report_name': 'av_inventory',
        'custom': True,
        'report_path': '/ConfigMgr_Y01/Yandex/Состояние антивирусного приложения на компьютерах определенной коллекции',
        'params': {
            'CollId': 'SMSDM003'
        }
    },
    {
        'report_name': 'computers_stats',
        'report_path': '/ConfigMgr_Y01/Аналитика активов/Оборудование 01A - Сводная информация о компьютерах в указанной коллекции',
        'params': {
            'CollectionID': 'SMSDM003'
        }
    },
    {
        'report_name': 'bad_sccm',
        'report_path': '/ConfigMgr_Y01/Состояние клиентов/Сведения о неактивных клиентах',
        'params': {
            'CollID': 'SMSDM003'
        }
    },
]

cim_mapping = {
    'NetBIOS_Name': 'host',
    'Computer_Name': 'host',
    'ComputerName': 'host',
    'User_Name': 'user'
}

not_used = [
    {
        'report_name': 'computers_by_program',
        'report_path': '/ConfigMgr_Y01/Программы - Компании и продукты/Компьютеры с определенным программным обеспечением в меню установки и удаления программ',
        'params': {
            'filterwildcard': 'Kaspersky Endpoint Security%',
            'CollID': 'SMSDM003',
            'Version': ''
        }
    },
    {
        'report_name': 'computers_by_program',
        'report_path': '/ConfigMgr_Y01/Программы - Компании и продукты/Компьютеры с определенным программным обеспечением в меню установки и удаления программ',
        'params': {
            'filterwildcard': 'Dr.Web Agent%',
            'CollID': 'SMSDM003',
            'Version': ''
        }
    },
]


def get_report_from_sccm(report, client):
    report_path = report['report_path']
    params = []
    if report['params']:
        for k, v in report['params'].items():
            params.append(client.service.ParameterValue(k, v))
    params = client.service.ArrayOfParameterValue(params)
    result = client.service.LoadReport(Report=report_path)
    client.service.SetExecutionParameters(params, 'en-us', _soapheaders=[result.header])
    data = client.service.Render(Format='CSV', _soapheaders=[result.header])
    return data


def parse_native_report(data, report_name):
    data = data.split('\n')
    if len(data) < 5:
        return None
    headers_num = len(data[3].split(',')) // 2
    data = data[4:]
    headers = [header.replace(' ', '_') for header in data[0].split(',')]

    parsed_data = []
    for line in csv.reader(data):
        if not line:
            continue
        record = {'report_name': report_name}
        for i in range(headers_num):
            record[map_field(headers[i])] = line[headers_num+i].strip()
        parsed_data.append(record)

    return parsed_data


def parse_custom_report(data, report_name):
    data = data.split('\n')
    if len(data) < 4:
        return None
    headers_num = len(data[3].split(','))
    headers = [header.replace(' ', '_') for header in data[3].split(',')]
    data = data[4:]

    parsed_data = []
    for line in csv.reader(data):
        if not line:
            continue
        record = {'report_name': report_name}
        for i in range(headers_num):
            record[map_field(headers[i])] = line[i].strip()
        parsed_data.append(record)

    return parsed_data


def map_field(name):
    field = cim_mapping.get(name) or name
    return field.strip()


def main():
    hec = SplunkHECSender(token=hec_token, current_time_as_timestamp=True, hec_verify_ssl=False)
    session = Session()
    session.auth = HTTPBasicAuth(username, password)
    client = Client('https://{}/ReportServer/ReportExecution2005.asmx?wsdl'.format(sccm_host),
                    transport=Transport(session=session))

    client.service.ArrayOfParameterValue = client.get_type('ns0:ArrayOfParameterValue')
    client.service.ParameterValue = client.get_type('ns0:ParameterValue')
    for report in reports:
        result = get_report_from_sccm(report, client)
        if report.get('custom'):
            data = parse_custom_report(result.body.Result.decode("utf-8"), report.get('report_name'))
        else:
            data = parse_native_report(result.body.Result.decode("utf-8"), report.get('report_name'))
        if data:
            hec.send_data(data)


if __name__ == '__main__':
    main()
