import sys
import csv
import auth_client_parser


if __name__ == "__main__":

    infile = sys.stdin
    outfile = sys.stdout

    data = csv.DictReader(infile)
    output = csv.DictWriter(outfile, fieldnames=[
        'Session_id',
        'uid',
        'user_glogouted',
        'uids',
        'session_ts',
        'session_suspicious',
    ])
    output.writeheader()

    valid_status = auth_client_parser.ParseStatus.RegularMayBeValid
    for line in data:
        session_id = line.get('Session_id', None)
        if session_id:
            cookie = auth_client_parser.Cookie(session_id)
            if cookie.status == valid_status:
                output.writerow({
                    'Session_id': session_id,
                    'uid': cookie.default_user().uid,
                    'user_glogouted': cookie.default_user().glogouted,
                    'uids': ','.join([str(u.uid) for u in cookie.users()]),
                    'session_ts': cookie.session_info().ts,
                    'session_suspicious': cookie.session_info().suspicious,
                })
