#!/usr/bin/python
import dotenv
import pathlib
import sys
import os
import logging

from jinja2 import Environment, FileSystemLoader

logging.basicConfig(stream=sys.stdout, level=logging.INFO)


def fill_tpl():
    logging.info('Starting template filling')

    working_directory = pathlib.Path().resolve()
    list_of_envs = dotenv.dotenv_values()
    templates = list(working_directory.glob('**/*.tpl'))

    env = Environment(loader=FileSystemLoader(working_directory.as_posix()))
    for template in templates:
        config = env.get_template(template.as_posix())
        # render_config = config.render(**list_of_envs)
        render_config = config.render(**os.environ)
        with open(template.with_suffix(''), 'w') as fp:
            fp.write(render_config)
        logging.info(f'Processed render {template} to {template.with_suffix("")}')

    logging.info('Finished template filling')


def entrypoint():

    # from CMD we are getting ['script_name', '/bin/sh', '-c', ....] 
    # so with [3:] will remove unnecessary arguments
    original_entrypoint = ' '.join(sys.argv[3:])
    
    logging.info(f'Starting original entrypoing {original_entrypoint}')
    os.system(original_entrypoint)


if __name__ == "__main__":    
    
    fill_tpl()    
    entrypoint()
