import os
from jinja2 import Environment, FileSystemLoader
from dotenv import dotenv_values

def get_parametrs():
    config = dotenv_values(".env")
    list_of_envs = (dict(config))

    return list_of_envs


def get_templates():
    list_of_templates = []
    for root, dirs, files in os.walk("."):
        for file in files:
            if "tpl" in str(file):
                list_of_templates.append(file)

    return list_of_templates


def create_config(template,env, data):
    config = env.get_template(template)
    render_config = config.render(**data)
    with open(template[:-4], 'a+') as fp:
        fp.write(render_config)

    print(os.system("ls"))
    print(os.system("pwd"))
    return render_config


def main():
    print(os.system("ls"))
    list_of_envs = get_parametrs()
    data = list_of_envs
    templates = get_templates()
    env = Environment(loader=FileSystemLoader('.'))
    for template in templates:
        config = create_config(template, env, data)




if __name__ == "__main__":
    main()