package commands

import (
	"fmt"
	"os"

	"github.com/spf13/cobra"
	xzap "go.uber.org/zap"
	"go.uber.org/zap/zapcore"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

var (
	logger log.Logger
)

var rootCmd = &cobra.Command{
	Use:          "ypper",
	SilenceUsage: true,
	Short:        "PodSet resolver",
	PersistentPreRunE: func(cmd *cobra.Command, args []string) (err error) {
		logger, err = newLogger()
		if err != nil {
			return fmt.Errorf("failed to initialize logger: %w", err)
		}
		return nil
	},
}

func Main() {
	if err := rootCmd.Execute(); err != nil {
		os.Exit(1)
	}
}

func newLogger() (log.Logger, error) {
	return zap.New(xzap.Config{
		Level:            xzap.NewAtomicLevelAt(xzap.InfoLevel),
		Encoding:         "kv",
		OutputPaths:      []string{"stderr"},
		ErrorOutputPaths: []string{"stderr"},
		EncoderConfig: zapcore.EncoderConfig{
			MessageKey:     "msg",
			LevelKey:       "level",
			TimeKey:        "ts",
			CallerKey:      "caller",
			NameKey:        "logger",
			LineEnding:     zapcore.DefaultLineEnding,
			EncodeLevel:    zapcore.CapitalLevelEncoder,
			EncodeTime:     zapcore.ISO8601TimeEncoder,
			EncodeDuration: zapcore.SecondsDurationEncoder,
			EncodeCaller:   zapcore.ShortCallerEncoder,
		},
	})
}
