package yputil

import (
	"errors"
	"strings"
)

var (
	ErrNoStageInPodSet = errors.New("podset_id doesn't contains stage_id")
)

func PodSetToStage(podSetID string) (string, error) {
	if idx := strings.Index(podSetID, "."); idx > 0 {
		return podSetID[:idx], nil
	}

	return "", ErrNoStageInPodSet
}
