package exportdb

import (
	"fmt"
)

func upsertProjectsQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $projects AS List<Struct<
    system_id: Utf8,
    project: Utf8>>;

UPSERT INTO	projects
SELECT system_id, project FROM AS_TABLE($projects)
;
`, pathPrefix)
}

func upsertSSHPermissionsQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $permission AS List<Struct<
    system_id: Utf8,
    staff_user: Utf8>>;

UPSERT INTO	ssh_permissions
SELECT system_id, staff_user FROM AS_TABLE($permission)
;
`, pathPrefix)
}

func upsertRowACLQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $acl AS List<Struct<
    system_id: Utf8,
	user_id: Uint64,
	staff_user: Utf8>>;

UPSERT INTO	row_acl
SELECT system_id, user_id, staff_user FROM AS_TABLE($acl)
;
`, pathPrefix)
}

func upsertSSHUsageQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");
DECLARE $ssh_usage AS List<Struct<
    system_id: Utf8,
	sync_time: DateTime,
	staff_user: Utf8,
	target_user: Utf8,
	count: Uint32>>;

UPSERT INTO	ssh_usage
	(system_id, sync_time, staff_user, target_user, count)
SELECT system_id, sync_time, staff_user, target_user, count FROM AS_TABLE($ssh_usage)
;
`, pathPrefix)
}

func createCommonTablesQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

CREATE TABLE projects
(
    system_id  Utf8,
	project Utf8,

	PRIMARY KEY (system_id, project)
);

CREATE TABLE ssh_permissions
(
    system_id  Utf8,
	staff_user Utf8,

	PRIMARY KEY (system_id, staff_user)
);

CREATE TABLE row_acl
(
	system_id Utf8,
	user_id Uint64,
	staff_user Utf8,

	PRIMARY KEY (system_id, user_id)
);
`, pathPrefix)
}

func createSSHUsageQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

CREATE TABLE ssh_usage
(
    system_id  Utf8,
	sync_time   Datetime,
	staff_user  Utf8,
	target_user Utf8,
	count       Uint32,

	PRIMARY KEY (system_id, sync_time, staff_user)
);
`, pathPrefix)
}

func dropSSHAccessQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

DROP TABLE ssh_permissions;
`, pathPrefix)
}

func dropRowACLQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

DROP TABLE row_acl;
`, pathPrefix)
}

func dropProjectsQuery(pathPrefix string) string {
	return fmt.Sprintf(`
--!syntax_v1
PRAGMA TablePathPrefix("%s");

DROP TABLE projects;
`, pathPrefix)
}
