package nanny

const OnlineSummary = "ONLINE"

type Service struct {
	ID           string `json:"_id"`
	CurrentState struct {
		Content struct {
			Summary struct {
				Value string `json:"value"`
			} `json:"summary"`
		} `json:"content"`
	} `json:"current_state"`
	InfoAttrs InfoAttrs `json:"info_attrs"`
	AuthAttrs AuthAttrs `json:"auth_attrs"`
}

type InfoAttrs struct {
	Content struct {
		Category string `json:"category"`
	} `json:"content"`
}

type AuthAttrs struct {
	Content struct {
		Observers    ACL `json:"observers"`
		Owners       ACL `json:"owners"`
		ConfManagers ACL `json:"conf_managers"`
		OpsManagers  ACL `json:"ops_managers"`
	} `json:"content"`
}

type ACL struct {
	Logins []string `json:"logins"`
	Groups []string `json:"groups"`
}
