package staff

type User struct {
	Login  string
	UID    uint64
	Groups []int
}

type staffErrorResponse struct {
	Msg string `json:"error_message"`
}

type staffResponse struct {
	Links struct {
		Next string `json:"next"`
	} `json:"links"`
}

type staffPersonsResponse struct {
	staffResponse
	Result []struct {
		Login  string `json:"login"`
		UID    uint64 `json:"uid,string"`
		Groups []struct {
			Group struct {
				ID int `json:"id"`
			} `json:"group"`
		} `json:"groups"`
	} `json:"result"`
}
