package yp

import "a.yandex-team.ru/library/go/core/log"

type Option interface {
	isOption()
}

type AuthTokenOption struct {
	Option
	token string
}

func WithAuthToken(token string) Option {
	return AuthTokenOption{
		token: token,
	}
}

type LoggerOption struct {
	Option
	log log.Logger
}

func WithLogger(l log.Logger) Option {
	return LoggerOption{
		log: l,
	}
}
