package main

import (
	"context"
	"log"
	"os"
	"os/signal"
	"runtime"
	"syscall"
	"time"

	"github.com/spf13/pflag"

	"a.yandex-team.ru/security/tools/brobot/pkg/app"
)

const (
	shutdownDeadline = time.Second * 20
)

func init() {
	runtime.GOMAXPROCS(2)
}

func main() {
	opts := app.Options{
		AuthKey:    os.Getenv("BROBOT_API_TOKEN"),
		ProxyAddr:  os.Getenv("BROBOT_PROXY"),
		PublicPath: "./public",
	}
	var appAddr string
	pflag.StringVar(&appAddr, "addr", ":80", "listen address")
	pflag.StringVar(&opts.PublicPath, "public", opts.PublicPath, "path to public folder")
	pflag.StringVar(&opts.ProxyAddr, "proxy", os.Getenv("BROBOT_PROXY"), "proxy addr")
	pflag.Parse()

	srv := app.New(opts)
	stopChan := make(chan os.Signal, 1)
	signal.Notify(stopChan, syscall.SIGINT, syscall.SIGTERM)

	errChan := make(chan error, 1)
	go func() {
		if err := srv.ListenAndServe(appAddr); err != nil {
			errChan <- err
		}
	}()

	select {
	case <-stopChan:
		ctx, cancel := context.WithTimeout(context.Background(), shutdownDeadline)
		defer cancel()
		if err := srv.Shutdown(ctx); err != nil {
			log.Printf("failed to shutdown: %v\n", err)
		}

	case err := <-errChan:
		log.Println(err.Error())
	}
}
