package app

import (
	"net/http"

	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/tools/brobot/pkg/worker"
)

func (a *App) doIndex(c echo.Context) error {
	return c.Render(http.StatusOK, "index", echo.Map{
		"browserName": a.worker.BrowserName(),
		"log":         a.worker.Log(),
	})
}

func (a *App) doPing(c echo.Context) error {
	return c.String(http.StatusOK, "OK")
}

func (a *App) doNavigate(c echo.Context) error {
	var task worker.TaskNavigate
	err := c.Bind(&task)
	if err != nil {
		return err
	}

	task.CID, err = worker.GenCID()
	if err != nil {
		return err
	}

	err = a.worker.NewTask(c.Request().Context(), &task)
	if err != nil {
		return err
	}

	return c.JSON(http.StatusOK, echo.Map{
		"cid": task.CID,
	})
}
